/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.gamestages.packet;

import java.util.function.Supplier;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.gamestages.data.GameStageSaveHandler;
import net.darkhax.gamestages.data.StageData;
import net.darkhax.gamestages.event.StagesSyncedEvent;
import net.darkhax.gamestages.packet.MessageStages;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class GameStagesPacketHandler {
    private final String PROTOCOL = "8";
    private final SimpleChannel channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("gamestages", "main"), () -> "8", "8"::equals, "8"::equals);

    public GameStagesPacketHandler() {
        this.channel.registerMessage(0, MessageStages.class, this::encodeStageMessage, this::decodeStageMessage, this::processSyncStagesMessage);
    }

    public void syncPlayerStages(ServerPlayer player, MessageStages msg) {
        this.channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)msg);
    }

    private MessageStages decodeStageMessage(FriendlyByteBuf buffer) {
        return new MessageStages(Serializers.STRING.fromByteBufList(buffer));
    }

    private void processSyncStagesMessage(MessageStages message, Supplier<NetworkEvent.Context> ctx) {
        StageData clientData = new StageData();
        for (String stageName : message.getStages()) {
            clientData.addStage(stageName);
        }
        GameStageSaveHandler.setClientData(clientData);
        MinecraftForge.EVENT_BUS.post((Event)new StagesSyncedEvent(clientData));
    }

    private void encodeStageMessage(MessageStages packet, FriendlyByteBuf buffer) {
        Serializers.STRING.toByteBufList(buffer, packet.getStages());
    }
}

